{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:12:49 $                                        =}
{========================================================================}
unit Form_Equalizer;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMSystem,
  MMObj,
  MMUtils,
  MMSlider,
  MMHTimer,
  MMEQ,
  MMDSPMtr,
  MMWavOut,
  MMRingBf,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMDesign,
  MMLevel,
  MMLEDS,
  MMDIBCv,
  MMSpectr,
  MMVolume,
  MMWheel, MMHook;

type
  TFormEqualizer = class(TForm)
    MMDesigner1: TMMDesigner;
    MMWaveIn: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMRingBuffer1: TMMRingBuffer;
    MMWaveOut1: TMMWaveOut;
    EQLeft: TMMEqualizer;
    MMHiTimer1: TMMHiTimer;
    EQRight: TMMEqualizer;
    MasterVolume: TMMVolume;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    dbLabel0: TLabel;
    dBLabel1: TLabel;
    dBLabel2: TLabel;
    dbLabel3: TLabel;
    dBLabel4: TLabel;
    dBLabel5: TLabel;
    dBLabel6: TLabel;
    dBLabel7: TLabel;
    dBLabel8: TLabel;
    dBLabel9: TLabel;
    MMSlider16: TMMSlider;
    MMSlider17: TMMSlider;
    MMSlider18: TMMSlider;
    MMSlider19: TMMSlider;
    MMSlider20: TMMSlider;
    MMSlider21: TMMSlider;
    MMSlider22: TMMSlider;
    MMSlider23: TMMSlider;
    MMSlider29: TMMSlider;
    MMSlider15: TMMSlider;
    Panel7: TPanel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    dBLabel10: TLabel;
    dBLabel11: TLabel;
    dBLabel12: TLabel;
    dBLabel13: TLabel;
    dBLabel14: TLabel;
    dBLabel15: TLabel;
    dBLabel16: TLabel;
    dBLabel17: TLabel;
    dBLabel18: TLabel;
    dBLabel19: TLabel;
    MMSlider1: TMMSlider;
    MMSlider2: TMMSlider;
    MMSlider3: TMMSlider;
    MMSlider4: TMMSlider;
    MMSlider5: TMMSlider;
    MMSlider6: TMMSlider;
    MMSlider7: TMMSlider;
    MMSlider8: TMMSlider;
    MMSlider9: TMMSlider;
    MMSlider30: TMMSlider;
    ControlPanel: TPanel;
    Spectrum2: TMMSpectrum;
    Spectrum1: TMMSpectrum;
    StartBtn: TButton;
    StopBtn: TButton;
    Label4: TLabel;
    DSPLabel: TLabel;
    Label25: TLabel;
    LEDOver: TMMLED;
    VolumeMaster: TMMWheel;
    Label7: TLabel;
    DSPMeter: TMMDSPMeter;
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMHiTimer1Timer(Sender: TObject);
    procedure MMWaveInStart(Sender: TObject);
    procedure MMWaveInStop(Sender: TObject);
    procedure EQPcmOverflow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MMSliderChange(Sender: TObject);
    procedure MMSlider1Change(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
  public
  end;

var
  FormEqualizer: TFormEqualizer;

type
  TBand  = record
    f1     : Float;
    f2     : Float;
    dbLblL : TLabel;
    dbLblR : TLabel;
  end;

const
  nBands = 10;
  EQBands: array[0..nBands-1] of TBand =
           ((f1:    0; f2:    32; dbLblL: nil; dbLblR: nil),
            (f1:   32; f2:    64; dbLblL: nil; dbLblR: nil),
            (f1:   64; f2:   130; dbLblL: nil; dbLblR: nil),
            (f1:  130; f2:   260; dbLblL: nil; dbLblR: nil),
            (f1:  260; f2:   500; dbLblL: nil; dbLblR: nil),
            (f1:  500; f2:  1000; dbLblL: nil; dbLblR: nil),
            (f1: 1000; f2:  2000; dbLblL: nil; dbLblR: nil),
            (f1: 2000; f2:  4000; dbLblL: nil; dbLblR: nil),
            (f1: 4000; f2:  8300; dbLblL: nil; dbLblR: nil),
            (f1: 8300; f2: 16500; dbLblL: nil; dbLblR: nil));

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.AppMessage(var Msg: TMsg; var Handled: Boolean);
begin
  with Msg do
  if Active and (Message = WM_MOUSEMOVE) then
  begin
     if FindControl(Msg.HWND) is TMMSlider then
     begin
        Windows.SetFocus(Msg.HWND);
     end;
  end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.FormCreate(Sender: TObject);
var
   i: integer;

begin
   Application.OnMessage := AppMessage;

   { a simple example how to setup the bands at runtime }

   for i := 0 to nBands-1 do
   with EQBands[i] do
   begin
      EQLeft.Filters.AddObject(TMMEQFilter.CreateEx(f1,f2,0));
      dBLblL := TLabel(FindComponent('dBLabel'+IntToStr(i)));

      EQRight.Filters.AddObject(TMMEQFilter.CreateEx(f1,f2,0));
      dBLblR := TLabel(FindComponent('dBLabel'+IntToStr(i+10)));
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop and close the device }
   MMWaveIn.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.FormShow(Sender: TObject);
begin
   { is the current device a Full-Duplex device ? }
   if not DeviceFullDuplex(MMWaveIn.DeviceID,MMWaveIn.PWaveFormat) then
   begin
      if (MMWaveIn.Mode = mStereo) then
          MessageDlg('You need a "Full-Duplex" device to run this demo'#10#13+
                     'Some older devices do not support Full-Duplex in stereo.', mtError, [mbOK], 0)
      else
          MessageDlg('You need a "Full-Duplex" device to run this demo', mtError, [mbOK], 0);

      StopBtn.Enabled := False;
      StartBtn.Enabled := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.StartBtnClick(Sender: TObject);
begin
   { open and start the device }
   MMWaveIn.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.StopBtnClick(Sender: TObject);
begin
   { stop and close the device }
   MMWaveIn.Close;

   DSPLabel.Caption := '0 %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.MMHiTimer1Timer(Sender: TObject);
begin
   DSPLabel.Caption := IntToStr(DSPMeter.Value)+ ' %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.MMWaveInStart(Sender: TObject);
begin
   MMHiTimer1.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.MMWaveInStop(Sender: TObject);
begin
   MMHiTimer1.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.EQPcmOverflow(Sender: TObject);
begin
   LEDOver.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.MMSliderChange(Sender: TObject);
begin
   with (Sender as TMMSlider) do
   begin
      EQLeft.Filters[Tag].Gain := Position;
      EQBands[Tag].dbLblL.Caption := IntToStr(Position);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.MMSlider1Change(Sender: TObject);
begin
   with (Sender as TMMSlider) do
   begin
      EQRight.Filters[Tag].Gain := Position;
      EQBands[Tag].dbLblR.Caption := IntToStr(Position);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormEqualizer.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

end.
